/*:
* @plugindesc HealthBar
* @author mrcopra
* 
*/

//////////////////////////////////////////////////////////////////////////////////////

var _Scene_Map_start = Scene_Map.prototype.start;
Scene_Map.prototype.start = function() {
	_Scene_Map_start.call(this);
	this._myWindow = new My_Window(819, 0);
	this.addWindow(this._myWindow);
	this._enemyWindow = new Enemy_window(100, 408);
	this.addWindow(this._enemyWindow);

	$gameSwitches.setValue(115, false)
	$gameSwitches.setValue(117, true)
};


var _Scene_Map_update = Scene_Map.prototype.update;
Scene_Map.prototype.update = function() {
	_Scene_Map_update.call(this);

	if (s(117)) { //refresh bars
		if (!s(118)) { //hide port name
			this._myWindow.visible = true;
			this._myWindow.refresh();
		}
		else {
			this._myWindow.visible = false;
		}
		
		this._myWindow.refresh();
		if (s(2) && !this._historyWindow.visible) {
			this._enemyWindow.visible = true;
			this._enemyWindow.refresh();
		}
		else {
			this._enemyWindow.visible = false;
		}
		$gameSwitches.setValue(117, false)
	}
	
	if (!$gameSwitches.value(115)) { //load saved text on map
		$gameMessage.setFaceImage("", 0);
		$gameMessage.setBackground(2);
		$gameMessage.setPositionType(2);
		$gameMessage.addText(v(160) + "``");
		$gameSwitches.setValue(115, true)
	}
};


var _Scene_Equip_start = Scene_Equip.prototype.start;
Scene_Equip.prototype.start = function() {
	_Scene_Equip_start.call(this);
	this._myWindow = new My_Window(819, 0);
	this.addWindow(this._myWindow);
	$gameSwitches.setValue(117, true) //refresh hp bars
};

var _Scene_Equip_update = Scene_Equip.prototype.update;
Scene_Equip.prototype.update = function() {
	_Scene_Equip_update.call(this);
	
	if ($gameSwitches.value(117)) { //refresh bars
		this._myWindow.visible = true;
		this._myWindow.refresh();
		$gameSwitches.setValue(117, false)
	}
};


var _Scene_ItemBase_start = Scene_ItemBase.prototype.start;
Scene_ItemBase.prototype.start = function() {
	_Scene_ItemBase_start.call(this);
	this._myWindow = new My_Window(819, 0);
	this.addWindow(this._myWindow);
	$gameSwitches.setValue(117, true) //refresh hp bars
};

var _Scene_ItemBase_update = Scene_ItemBase.prototype.update;
Scene_ItemBase.prototype.update = function() {
	_Scene_ItemBase_update.call(this);
	
	if ($gameSwitches.value(117)) { //refresh bars
		this._myWindow.visible = true;
		this._myWindow.refresh();
		$gameSwitches.setValue(117, false)
	}
};


var _Scene_Storage_start = Scene_Storage.prototype.start;
Scene_Storage.prototype.start = function() {
	_Scene_Storage_start.call(this);
	this._myWindow = new My_Window(819, 0);
	this.addWindow(this._myWindow);
	$gameSwitches.setValue(117, true) //refresh hp bars
};

var _Scene_Storage_update = Scene_Storage.prototype.update;
Scene_Storage.prototype.update = function() {
	_Scene_Storage_update.call(this);
	
	if ($gameSwitches.value(117)) { //refresh bars
		this._myWindow.visible = true;
		this._myWindow.refresh();
		$gameSwitches.setValue(117, false)
	}
};

var _Scene_Options_start = Scene_Options.prototype.start;
Scene_Options.prototype.start = function() {
	_Scene_Options_start.call(this);
	this._myWindow = new My_Window(819, 0);
	this.addWindow(this._myWindow);
	$gameSwitches.setValue(117, true) //refresh hp bars
};

var _Scene_Options_update = Scene_Options.prototype.update;
Scene_Options.prototype.update = function() {
	_Scene_Options_update.call(this);
	
	if ($gameSwitches.value(117)) { //refresh bars
		this._myWindow.visible = true;
		this._myWindow.refresh();
		$gameSwitches.setValue(117, false)
	}
};



var _Scene_GameEnd_start = Scene_GameEnd.prototype.start;
Scene_GameEnd.prototype.start = function() {
	_Scene_GameEnd_start.call(this);
	this._myWindow = new My_Window(819, 0);
	this.addWindow(this._myWindow);
	$gameSwitches.setValue(117, true) //refresh hp bars
};

var _Scene_GameEnd_update = Scene_GameEnd.prototype.update;
Scene_GameEnd.prototype.update = function() {
	_Scene_GameEnd_update.call(this);
	if ($gameSwitches.value(117)) { //refresh bars
		this._myWindow.visible = true;
		this._myWindow.refresh();
		$gameSwitches.setValue(117, false)
	}
};




var _Scene_Shop_start = Scene_Shop.prototype.start;
Scene_Shop.prototype.start = function() {
	_Scene_Shop_start.call(this);
	this._myWindow = new My_Window(819, 0);
	this.addWindow(this._myWindow);
	$gameSwitches.setValue(117, true) //refresh hp bars
};

var _Scene_Shop_update = Scene_Shop.prototype.update;
Scene_Shop.prototype.update = function() {
	_Scene_Shop_update.call(this);
	if ($gameSwitches.value(117)) { //refresh bars
		this._myWindow.visible = true;
		this._myWindow.refresh();
		$gameSwitches.setValue(117, false)
	}
};


var _Scene_File_start = Scene_File.prototype.start;
Scene_File.prototype.start = function() {
	_Scene_File_start.call(this);
	this._myWindow = new My_Window(819, 0);
	this.addWindow(this._myWindow);
	$gameSwitches.setValue(117, true) //refresh hp bars
};

var _Scene_File_update = Scene_File.prototype.update;
Scene_File.prototype.update = function() {
	_Scene_File_update.call(this);
	
	if ($gameSwitches.value(117)) { //refresh bars
		if (!$gameSwitches.value(118)) {
			this._myWindow.visible = true;
			this._myWindow.refresh();
		}
		else {
			this._myWindow.visible = false;
		}
		$gameSwitches.setValue(117, false)
	}
};

var _Scene_Save_start = Scene_Save.prototype.start;
Scene_Save.prototype.start = function() {
	_Scene_Save_start.call(this);
	this._myWindow = new My_Window(819, 0);
	this.addWindow(this._myWindow);
	$gameSwitches.setValue(117, true) //refresh hp bars
};

var _Scene_Save_update = Scene_Save.prototype.update;
Scene_Save.prototype.update = function() {
	_Scene_Save_update.call(this);
	
	if ($gameSwitches.value(117)) { //refresh bars
		if (!$gameSwitches.value(118)) {
			this._myWindow.visible = true;
			this._myWindow.refresh();
		}
		else {
			this._myWindow.visible = false;
		}
		$gameSwitches.setValue(117, false)
	}
};


Scene_Menu.prototype.start = function() {
	Scene_MenuBase.prototype.start.call(this);
	this._myWindow = new My_Window(819, 0);
	this.addWindow(this._myWindow);
	this._myWindow.visible = true
	$gameSwitches.setValue(117, true) //refresh hp bars
};

var _Scene_Menu_update = Scene_Menu.prototype.update;
Scene_Menu.prototype.update = function() {
	_Scene_Menu_update.call(this);
	
	if ($gameSwitches.value(117)) { //refresh bars
		if (!$gameSwitches.value(118)) {
			this._myWindow.visible = true;
			this._myWindow.refresh();
		}
		else {
			this._myWindow.visible = false;
		}
		$gameSwitches.setValue(117, false)
	}
};


 function My_Window() {
 	this.initialize.apply(this, arguments);
 }

    My_Window.prototype = Object.create(Window_Base.prototype);
    My_Window.prototype.constructor = My_Window;
		
	My_Window.prototype.standardPadding = function() {
    return 0;
	};


My_Window.prototype.initialize = function(x, y) {
	Window_Base.prototype.initialize.call(this, x, y, 461, 720);
	this._value = -1;
	this.refresh();
	this.opacity = 0

	this.visible = false
};

My_Window.prototype.refresh = function(){
	this.contents.clear();
	
	if ($gameSwitches.value(179)) {
		var y = 40
		var x = 289
		var y_sp = 31
		var rate
		
		this.contents.fontSize = 20;
		if (Utils.isMobileDevice()) {this.contents.fontSize = 18}
				
		this.changeTextColor(this.textColor(4));
		this.drawText("Str", x, y, 100, 'center');
		if (str() > v(103)) {this.changeTextColor(this.textColor(24))}
		else if (str() < v(103)) {this.changeTextColor(this.textColor(2))}
		else {this.changeTextColor(this.normalColor());}
		this.drawText(str(), x + 62, y, 40, 'right');
		rate = Math.min(v(123) / ((v(103) + 1) * (v(103) + 2)), 1)
		this.drawGauge(x + 105, y - 14, 64, 4, rate, this.textColor(4), this.textColor(12));
		y += y_sp
		
		
		this.changeTextColor(this.textColor(4));
		this.drawText("Nim", x, y, 100, 'center');
		if (nim() > v(105)) {this.changeTextColor(this.textColor(24))}
		else if (nim() < v(105)) {this.changeTextColor(this.textColor(2))}
		else {this.changeTextColor(this.normalColor());}
		this.drawText(nim(), x + 62, y, 40, 'right');
		rate = Math.min(v(125) / ((v(105) + 1) * (v(105) + 2)), 1)
		this.drawGauge(x + 105, y - 14, 64, 4, rate, this.textColor(4), this.textColor(12));
		y += y_sp
		
		
		this.changeTextColor(this.textColor(4));
		this.drawText("Spe", x, y, 100, 'center');
		if (spe() > v(107)) {this.changeTextColor(this.textColor(24))}
		else if (spe() < v(107)) {this.changeTextColor(this.textColor(2))}
		else {this.changeTextColor(this.normalColor());}
		this.drawText(spe(), x + 62, y, 40, 'right');
		rate = Math.min(v(127) / ((v(107) + 1) * (v(107) + 2)), 1)
		this.drawGauge(x + 105, y - 14, 64, 4, rate, this.textColor(4), this.textColor(12));
		y += y_sp
		

		this.changeTextColor(this.textColor(4));
		this.drawText("Sen", x, y, 100, 'center');
		if (sen() > v(109)) {this.changeTextColor(this.textColor(24))}
		else if (sen() < v(109)) {this.changeTextColor(this.textColor(2))}
		else {this.changeTextColor(this.normalColor());}
		this.drawText(sen(), x + 62, y, 40, 'right');
		rate = Math.min(v(129) / ((v(109) + 1) * (v(109) + 2)), 1)
		this.drawGauge(x + 105, y - 14, 64, 4, rate, this.textColor(4), this.textColor(12));
		y += y_sp

		this.changeTextColor(this.textColor(4));
		this.drawText("Mys", x, y, 100, 'center');
		if (mys() > v(104)) {this.changeTextColor(this.textColor(24))}
		else if (mys() < v(104)) {this.changeTextColor(this.textColor(2))}
		else {this.changeTextColor(this.normalColor());}
		this.drawText(mys(), x + 62, y, 40, 'right');
		rate = Math.min(v(124) / ((v(104) + 1) * (v(104) + 2)), 1)
		this.drawGauge(x + 105, y - 14, 64, 4, rate, this.textColor(4), this.textColor(12));
		y += y_sp


		this.changeTextColor(this.textColor(4));
		this.drawText("Res", x, y, 100, 'center');
		if (res() > v(106)) {this.changeTextColor(this.textColor(24))}
		else if (res() < v(106)) {this.changeTextColor(this.textColor(2))}
		else {this.changeTextColor(this.normalColor());}
		this.drawText(res(), x + 62, y, 40, 'right');
		rate = Math.min(v(126) / ((v(106) + 1) * (v(106) + 2)), 1)
		this.drawGauge(x + 105, y - 14, 64, 4, rate, this.textColor(4), this.textColor(12));
		y += y_sp
		

		this.changeTextColor(this.textColor(4));
		this.drawText("Ins", x, y, 100, 'center');
		if (ins() > v(108)) {this.changeTextColor(this.textColor(24))}
		else if (ins() < v(108)) {this.changeTextColor(this.textColor(2))}
		else {this.changeTextColor(this.normalColor());}
		this.drawText(ins(), x + 62, y, 40, 'right');
		rate = Math.min(v(128) / ((v(108) + 1) * (v(108) + 2)), 1)
		this.drawGauge(x + 105, y - 14, 64, 4, rate, this.textColor(4), this.textColor(12));
		y += y_sp
		

		this.changeTextColor(this.textColor(4));
		this.drawText("Ero", x, y, 100, 'center');
		if (ero() > v(110)) {this.changeTextColor(this.textColor(24))}
		else if (ero() < v(110)) {this.changeTextColor(this.textColor(2))}
		else {this.changeTextColor(this.normalColor());}
		this.drawText(ero(), x + 62, y, 40, 'right');
		rate = Math.min(v(130) / ((v(110) + 1) * (v(110) + 2)), 1)
		this.drawGauge(x + 105, y - 14, 64, 4, rate, this.textColor(4), this.textColor(12));
		this.changeTextColor(this.textColor(0));

		
		
		y += 116
		
		
		var hp = v(8)
		var mhp = v(9)
	
		if (mhp > 0) {rate = hp / mhp}
		else {rate = 0}
	
		if (rate < 0) { rate = 0 }
		if (rate > 1) { rate = 1 }

		var col1 = "100 255 175"
		var col2 = "100 100 255"

		col1 = this.convert_color(col1)
		col2 = this.convert_color(col2)
	
		var lust = v(10)
		var mlust = 100
		
		if (mlust > 0) {rate = lust / mlust}
		else {rate = 0}
		
		if (rate < 0) { rate = 0 }
		if (rate > 1) { rate = 1 }

		var col3 = "100 100 255"
		var col4 = "255 175 255"

		col3 = this.convert_color(col3)
		col4 = this.convert_color(col4)
		
		
		
		var mana = v(41)
		var mmana = v(42)
		
		if (mmana > 0) {rate = mana / mmana}
		else {rate = 0}
		
		if (rate < 0) { rate = 0 }
		if (rate > 1) { rate = 1 }

		var col5 = "255 255 100"
		var col6 = "40 255 50"

		col5 = this.convert_color(col5)
		col6 = this.convert_color(col6)


		this.contents.outlineWidth = 3;
		this.contents.outlineColor = 'rgba(0, 0, 0, 0.7)';

		y += 34
		y_sp = 42
		
//			this.changeTextColor(this.textColor(4))
		//hp gauges
		
		if (v(8) / v(9) * 100 <= 25) {this.changeTextColor(this.textColor(18)) }
		else if (v(8) / v(9) * 100 <= 50) {this.changeTextColor(this.textColor(2)) }
		
		this.drawText(v(8), 327, y, 150, 'left');
		this.changeTextColor(this.textColor(0))
		this.drawText("    / " + v(9), 327, y, 150, 'left');
		this.drawGauge(343, y+3, 115, 6, hp / mhp, col1, col2)

		y += y_sp
		
		if ($gameSelfSwitches.value([166, 18, 'A'])) { //learned magic
			this.drawGauge(343, y+3, 115, 6, mana / mmana, col5, col6)
			this.drawText(v(41), 327, y, 150, 'left');
			this.drawText("    / " + v(42), 327, y, 150, 'left');
		}
		else {
			this.drawGauge(343, y+3, 115, 6, 0, col5, col6)
			this.drawText("0   / 0", 327, y, 150, 'left');
		}
		
		y += y_sp
		if (v(10) >= 75) {this.changeTextColor(this.textColor(27)) }
		else if (v(10) >= 50) {this.changeTextColor(this.textColor(5)) }
		this.drawText(v(10), 327, y, 150, 'left');
		this.changeTextColor(this.textColor(0))
		this.drawText("    / 100", 327, y, 150, 'left');
		this.drawGauge(343, y+3, 115, 6, lust / mlust, col3, col4)
		
		
		
		y += y_sp
		this.changeTextColor(this.textColor(4))
		this.drawText("Credits", 308, y+5, 146, 'center');
		this.changeTextColor(this.textColor(0))
		
		this.drawText($gameParty.gold().toString().replace(/\B(?=(\d{3})+(?!\d))/g, ","), 
		  308, y + 28, 146, 'center');

		y += y_sp
		y += 14
		this.changeTextColor(this.textColor(4))
		this.drawText("Location", 308, y+5, 146, 'center');
		this.changeTextColor(this.textColor(0))
		
		if ($gameActors.actor(3)._name.length > 15) {
			var ss = $gameActors.actor(3)._name.split(" ")
			var s1 = ""
			var s2 = ""
			
			for (var i = 0; i < ss.length; i++) {
				if ((s1 + ss[i]).length <= 16) {s1 += ss[i] + " "	}
				else {break}
			}
			s1 = s1.trim()
			
			for (i = i; i < ss.length; i++) {
				s2 += ss[i] + " "
			}
			s2 = s2.trim()
			
			this.drawText(s1, 308, y + 28, 146, 'center');
			this.drawText(s2, 308, y + 56, 146, 'center');
		}
		else {
			this.drawText($gameActors.actor(3)._name, 308, y + 28, 146, 'center');
		}
		

		
		y = 669
		x = 9
		
		this.contents.fontSize = 22
		if (Utils.isMobileDevice()) {this.contents.fontSize = 20}
		
		
		if ($gameSelfSwitches.value([5, 20, 'A'])) { //using last name
			this.drawText($gameActors.actor(1)._name + " " + $gameActors.actor(2)._name, 0, y, 302, 'center');
		}
		else {
			this.drawText($gameActors.actor(1)._name, 0, y, 302, 'center');
		}
		
		this.contents.fillRect(31, y + 35, 240, 3, 'black')
		this.contents.fillRect(32, y + 36, 238, 1, 'white')
		
		
		
	}
	else {
		
		y = 669
		x = 9
		
		this.contents.fontSize = 22
		if (Utils.isMobileDevice()) {this.contents.fontSize = 20}
		
		if ($gameSelfSwitches.value([5, 20, 'A'])) { //using last name
			this.drawText($gameActors.actor(1)._name + " " + $gameActors.actor(2)._name, 0, y, 302, 'center');
		}
		else {
			this.drawText($gameActors.actor(1)._name, 0, y, 302, 'center');
		}
		
		this.contents.fillRect(31, y + 35, 240, 3, 'black')
		this.contents.fillRect(32, y + 36, 238, 1, 'white')
	}

};


My_Window.prototype.convert_color = function(input){
	parts = input.match(/^(\d+)\s*(\d+)\s*(\d+)$/);
	delete (parts[0]);
	for (var i = 1; i <= 3; ++i) {
			parts[i] = parseInt(parts[i]).toString(16);
			if (parts[i].length == 1) parts[i] = '0' + parts[i];
	}
	return '#'+parts.join('').toUpperCase();
};

 
 
function Enemy_window() {
 	this.initialize.apply(this, arguments);
}

    Enemy_window.prototype = Object.create(My_Window.prototype);
    Enemy_window.prototype.constructor = Enemy_window;
		
Enemy_window.prototype.initialize = function(x, y) {
	Window_Base.prototype.initialize.call(this, x, y, 140, 60);
	this._value = -1;
	this.refresh();
	this.opacity = 0
	this.visible = false
};

Enemy_window.prototype.refresh = function(){
	this.contents.clear();
	
	if ($gameSwitches.value(2)) { //enemy
		var hp = v(28)
		var mhp = v(29)
		
		if (mhp > 0) {rate = hp / mhp}
		else {rate = 0}
		
		if (rate < 0) { rate = 0 }
		if (rate > 1) { rate = 1 }

		var col1 = "100 255 175"
		var col2 = "100 100 255"
	//	var col1 = "253 32 32"
	//	var col2 = "169 3 2"
		
		col1 = this.convert_color(col1)
		col2 = this.convert_color(col2)
		
		var lust = v(30)
		var mlust = 100
		
		if (mlust > 0) {rate = lust / mlust}
		else {rate = 0}
		
		if (rate < 0) { rate = 0 }
		if (rate > 1) { rate = 1 }

		var col3 = "100 100 255"
		var col4 = "255 175 255"
	
		col3 = this.convert_color(col3)
		col4 = this.convert_color(col4)				
	
	
		this.drawGauge(0, 0, 130, 6, hp / mhp, col1, col2)
		this.drawGauge(0, 17, 130, 6, lust / mlust, col3, col4)				
	}
};

 

Window_Base.prototype.drawGauge = function(x, y, width, height, rate, color1, color2) {
    var fillW = Math.floor(width * rate);
    var gaugeY = y + this.lineHeight() - 9;
	
    this.contents.fillRect(x, 	  gaugeY,     width + 4, height + 4, 'black'); //outer
    this.contents.fillRect(x + 1, gaugeY + 1, width + 2, height + 2, 'white'); //white
    this.contents.fillRect(x + 2, gaugeY + 2, width,	 height, 	 'black'); //inner
		if (fillW >= 1) {this.contents.gradientFillRect(x + 2, gaugeY + 2, fillW, height, color1, color2) }
};


Window_Base.prototype.drawGauge2 = function(x, y, width, height, rate, color1, color2) {
    var fillW = Math.floor(width * rate);
    var gaugeY = y + this.lineHeight() - 9;
	
    this.contents.fillRect(x, 	  gaugeY,     width + 4, height + 4, 'black'); //outer
    this.contents.fillRect(x + 1, gaugeY + 1, width + 2, height + 2, 'white'); //white
    this.contents.fillRect(x + 2, gaugeY + 2, width,	 height, 	 'black'); //inner
		if (fillW >= 1) {this.contents.gradientFillRect(x + 2 + (width - fillW), gaugeY + 2, fillW, height, color1, color2) }
};



Game_Interpreter.prototype.command320 = function() {
	var prevname = $gameActors.actor(3)._name
	
    var actor = $gameActors.actor(this._params[0]);
    if (actor) {
        actor.setName(this._params[1]);
    }
		
//when change area name, reset encounter stuff
	if (this._params[0] == 3 && $gameActors.actor(3)._name != prevname) { //area name
		$gameVariables.setValue(155, 0);
		$gameSwitches.setValue(121, false)
		$gameSwitches.setValue(117, true) //reset sidehud
	}
    return true;
};



